﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Configuration;
using System.Web;
using AZVIC.Ei8htPOS.Entities;
using System.Net.Mail;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.IO;

namespace AZVIC.Ei8htPOS.WebUI
{
    public static class WebUtilities
    {
        public static void ShowFadeMessage(Control requestControl, string message)
        {
            ScriptManager.RegisterStartupScript(requestControl, requestControl.GetType(), "Ei8ht POS", "$(function(){ShowFadeMessage('" + message + "');});", true);
        }
        public static void ShowMessage(Control requestControl,string Message, string Header = "Ei8ht POS")
        {
            ScriptManager.RegisterStartupScript(requestControl, requestControl.GetType(), "Ei8ht POS", "ShowAlert('" + Message + "','" + Header + "');", true);
        }

        public static void OpenAddEditDialog(Control requestControl, string header, string message, string redirectURL)
        {
            ScriptManager.RegisterStartupScript(requestControl, requestControl.GetType(), "Ei8ht POS", "$(function(){OpenAddEditDialog('" + header + "','" + message + "', '" + redirectURL + "' );});", true);
        }

        public static void OpenNewAddEditDialog(Control control, string header, string Message, string redirectURL)
        {
            ScriptManager.RegisterStartupScript(control, control.GetType(), "Ei8ht POS", "$(function(){ShowAddAlert('" + header + "','" + Message + "', '" + redirectURL + "' );});", true);
        }

        public static void OpenDialog(Control requestControl, string header, string message, string redirectURL)
        {
            ScriptManager.RegisterStartupScript(requestControl, requestControl.GetType(), "Ei8ht POS", "$(function(){OpenDialog('" + header + "','" + message + "', '" + redirectURL + "' );});", true);
        }

        public static void ShowErrorDialog(Control requestControl, string message)
        {
            ScriptManager.RegisterClientScriptBlock(requestControl, requestControl.GetType(), "Ei8ht POS", "$(function(){ShowDialog(true, '" + message.Trim() + "');});", true);
        }

        public static void ShowValidationError(Control requestControl, string message)
        {
            ScriptManager.RegisterClientScriptBlock(requestControl, requestControl.GetType(), "Ei8ht POS", "$(function(){" + message.Trim() + "});", true);
        }

        public static void RegisterScript(Control requestControl, string scriptContent)
        {
            ScriptManager.RegisterClientScriptBlock(requestControl, requestControl.GetType(), "Ei8ht POS", scriptContent.Trim(), true);
        }

        public static void RegisterStartupScript(Control ctrl, string ScriptContent)
        {
            ScriptManager.RegisterStartupScript(ctrl, ctrl.GetType(), "Ei8ht POS", ScriptContent, true);
        }

        public static void FillDropDownList<T>(DropDownList ddl, List<T> table, string value, string text)
        {
            ddl.DataSource = table;
            ddl.DataTextField = text;
            ddl.DataValueField = value;
            ddl.DataBind();
            ddl.Items.Insert(0, new ListItem("-- Please Select --", "0"));
            ddl.SelectedIndex = 0;
        }

        public static void FillCheckBoxList<T>(CheckBoxList cbList, List<T> table, string value, string text)
        {
            cbList.DataSource = table;
            cbList.DataTextField = text;
            cbList.DataValueField = value;
            cbList.DataBind();
        }

        public static string CreateFileWithUniqueName(string directory, string fileName, int maxAttempts = 1024)
        {
            if (fileName.Contains("Copy_"))
            {
                string[] split = fileName.Split(new string[] { "Copy", "_", "_" }, StringSplitOptions.None);
                fileName = split[3].ToString();
            }

            var fileBase = Path.GetFileNameWithoutExtension(fileName);
            var ext = Path.GetExtension(fileName);

            for (var index = 0; index < maxAttempts; index++)
            {
                var name = (index == 0) ? fileName : String.Format("Copy_{0}_{1}{2}", index, fileBase, ext);

                var fullPath = Path.Combine(directory, name);
                if (File.Exists(fullPath))
                    continue;

                return fullPath;
            }

            throw new Exception("Could not create unique filename in " + maxAttempts + " attempts");
        }
    }
}